//
//  FSFileListViewController.h
//  PDFReader
//
//  Created by Dong Li on 12-4-25.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import "IFViewController.h"
#import "FSFileNameViewController.h"
#import "IFActivityView.h"
#import <MessageUI/MessageUI.h>

@class FSFileItem;

@interface FSFileListViewController : IFViewController <UITableViewDataSource, UITableViewDelegate, UISearchDisplayDelegate, UISearchBarDelegate, UIActionSheetDelegate, UINavigationControllerDelegate, UIImagePickerControllerDelegate, MFMailComposeViewControllerDelegate, UIDocumentInteractionControllerDelegate> {
    UITableView *_tableView;
    FSFileListViewController *_nextFileListViewController;
    UISearchController *_fileSearchController;
    UILongPressGestureRecognizer *_longPressGestureRecognizer;
    FSFileItem *_fileItem;
    NSMutableArray *_filteredSubFiles;
    NSMutableArray *_selectedFiles;
    NSMutableArray *_normalToolbarItems;
    NSMutableArray *_editingToolbarItems;
    UIBarButtonItem *_editItem;
    UIBarButtonItem *_doneItem;
    NSIndexPath *_selectedIndexPath;
    NSIndexPath *_menuIndexPath;
    CGPoint _contentOffset;
    BOOL _editing;
    BOOL _longPressed;
    BOOL _inboxDirectory;
}

@property (nonatomic, retain, readonly) FSFileItem *fileItem;

+ (FSFileListViewController *)currentFileListViewController;

- (id)initWithFileItem:(FSFileItem *)fileItem;
- (id)initWithPath:(NSString *)path;
- (void)beginUpdate;
- (void)endUpdate;
- (void)refresh;
- (void)handleOpenPath:(NSString *)path;

@end
